<?php

namespace NumberToWords\NumberTransformer;

class EnglishNumberTransformerTest extends NumberTransformerTest
{
    protected function setUp(): void
    {
        $this->numberTransformer = new EnglishNumberTransformer();
    }

    public function providerItConvertsNumbersToWords(): array
    {
        return [
            [-3, 'minus three'],
            [-9539, 'minus nine thousand five hundred thirty-nine'],
            [0, 'zero'],
            [1, 'one'],
            [3, 'three'],
            [8, 'eight'],
            [9, 'nine'],
            [10, 'ten'],
            [11, 'eleven'],
            [12, 'twelve'],
            [16, 'sixteen'],
            [19, 'nineteen'],
            [20, 'twenty'],
            [21, 'twenty-one'],
            [25, 'twenty-five'],
            [26, 'twenty-six'],
            [30, 'thirty'],
            [31, 'thirty-one'],
            [40, 'forty'],
            [43, 'forty-three'],
            [50, 'fifty'],
            [55, 'fifty-five'],
            [58, 'fifty-eight'],
            [60, 'sixty'],
            [67, 'sixty-seven'],
            [70, 'seventy'],
            [79, 'seventy-nine'],
            [80, 'eighty'],
            [90, 'ninety'],
            [99, 'ninety-nine'],
            [100, 'one hundred'],
            [101, 'one hundred one'],
            [102, 'one hundred two'],
            [111, 'one hundred eleven'],
            [113, 'one hundred thirteen'],
            [120, 'one hundred twenty'],
            [121, 'one hundred twenty-one'],
            [199, 'one hundred ninety-nine'],
            [203, 'two hundred three'],
            [229, 'two hundred twenty-nine'],
            [287, 'two hundred eighty-seven'],
            [300, 'three hundred'],
            [356, 'three hundred fifty-six'],
            [410, 'four hundred ten'],
            [434, 'four hundred thirty-four'],
            [500, 'five hundred'],
            [578, 'five hundred seventy-eight'],
            [660, 'six hundred sixty'],
            [666, 'six hundred sixty-six'],
            [689, 'six hundred eighty-nine'],
            [729, 'seven hundred twenty-nine'],
            [894, 'eight hundred ninety-four'],
            [900, 'nine hundred'],
            [909, 'nine hundred nine'],
            [919, 'nine hundred nineteen'],
            [990, 'nine hundred ninety'],
            [999, 'nine hundred ninety-nine'],
            [1000, 'one thousand'],
            [1001, 'one thousand one'],
            [1010, 'one thousand ten'],
            [1015, 'one thousand fifteen'],
            [1097, 'one thousand ninety-seven'],
            [1100, 'one thousand one hundred'],
            [1104, 'one thousand one hundred four'],
            [1111, 'one thousand one hundred eleven'],
            [1243, 'one thousand two hundred forty-three'],
            [2000, 'two thousand'],
            [2385, 'two thousand three hundred eighty-five'],
            [3766, 'three thousand seven hundred sixty-six'],
            [4000, 'four thousand'],
            [4196, 'four thousand one hundred ninety-six'],
            [4538, 'four thousand five hundred thirty-eight'],
            [5000, 'five thousand'],
            [5020, 'five thousand twenty'],
            [5846, 'five thousand eight hundred forty-six'],
            [6459, 'six thousand four hundred fifty-nine'],
            [7232, 'seven thousand two hundred thirty-two'],
            [8569, 'eight thousand five hundred sixty-nine'],
            [9539, 'nine thousand five hundred thirty-nine'],
            [11000, 'eleven thousand'],
            [11001, 'eleven thousand one'],
            [21000, 'twenty-one thousand'],
            [21512, 'twenty-one thousand five hundred twelve'],
            [90000, 'ninety thousand'],
            [92100, 'ninety-two thousand one hundred'],
            [212112, 'two hundred twelve thousand one hundred twelve'],
            [720018, 'seven hundred twenty thousand eighteen'],
            [999000, 'nine hundred ninety-nine thousand'],
            [999999, 'nine hundred ninety-nine thousand nine hundred ninety-nine'],
            [1000000, 'one million'],
            [1001001, 'one million one thousand one'],
            [2000000, 'two million'],
            [3248518, 'three million two hundred forty-eight thousand five hundred eighteen'],
            [4000000, 'four million'],
            [5000000, 'five million'],
            [999000000, 'nine hundred ninety-nine million'],
            [999000999, 'nine hundred ninety-nine million nine hundred ninety-nine'],
            [999999000, 'nine hundred ninety-nine million nine hundred ninety-nine thousand'],
            [999999999, 'nine hundred ninety-nine million nine hundred ninety-nine thousand nine hundred ninety-nine'],
            [1174315110, 'one billion one hundred seventy-four million three hundred fifteen thousand one hundred ten'],
            [1174315119, 'one billion one hundred seventy-four million three hundred fifteen thousand one hundred nineteen'],
            [1800000006, 'one billion eight hundred million six'],
            [15174315119, 'fifteen billion one hundred seventy-four million three hundred fifteen thousand one hundred nineteen'],
            [35174315119, 'thirty-five billion one hundred seventy-four million three hundred fifteen thousand one hundred nineteen'],
            [935174315119, 'nine hundred thirty-five billion one hundred seventy-four million three hundred fifteen thousand one hundred nineteen'],
            [2935174315119, 'two trillion nine hundred thirty-five billion one hundred seventy-four million three hundred fifteen thousand one hundred nineteen'],
        ];
    }
}
