<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Sale _<?php echo e($purchase['Ref']); ?></title>
    <link rel="stylesheet" href="<?php echo e(public_path('css/pdf_style.css')); ?>" media="all" />
    <style>
      #products {
         min-height: 400px;
      }
    </style>
</head>

<body>
    <header style="text-align: center;">
        <img src="<?php echo e(public_path('/images/' . $societe_logo)); ?>" width="100%">
    </header>

    <table style="width: 100%;">
        <tr>

            <td>
                <?php if($societe->name == 'FUNCHAL TRANS SARL'): ?>
                    <span style="font-size: 15px; font-weight: 700;">FUNCHAL TRANS SARL</span><br />
                    Résidence habiba 2 etg n°56 Tanger.<br />
                    R.C:85291 -T.P:57102685<br />
                    IF : 24934253 - CNSS : 5668308
                <?php endif; ?>
            </td>
            <td style="width: 60%;" rowspan="2">
                <div style="border: 3px solid black; font-size: 16px; font-weight: 700; padding: 20px">
                    Fournisseur : <?php echo e($purchase['supplier_name']); ?><br />
                    ICE : <?php echo e($purchase['supplier_tax']); ?><br />
                    ADRESSE : <?php echo e($purchase['supplier_adr']); ?>

                </div>
            </td>

        </tr>
        <tr>
            <td>
                <span style="font-size: 16px; font-weight: 700; padding: 20px">
                    Bon de commande : <?php echo e(substr($purchase['Ref'], 3)); ?>

                </span>
            </td>
        </tr>
    </table>

    <br />

    <div style="min-height: <?php echo e($societe->name == 'TRANSLOGIA SARL' ? '400' : '500'); ?>px;">
        <table id="products" style="width: 100%; border-collapse: collapse;">
            <tr style="border: 1px solid black;">
                <th style="width: 12%; text-align: left; border-right: 1px solid black;">N°</th>
                <th style="width: 55%; text-align: left; border-right: 1px solid black;">Désignation</th>
                <th style="width: 18%; text-align: left; border-right: 1px solid black;">Qte</th>
                <th style="width: 18%; text-align: left; border-right: 1px solid black;">Prix</th>
                <th style="width: 15%; text-align: left;">Montant</th>
            </tr>
            <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr style="border: 1px solid black;">
                    <td style="border-right: 1px solid black;"><?php echo e($detail['code']); ?></td>
                    <td style="border-right: 1px solid black;"><?php echo e($detail['name']); ?></td>
                    <td style="border-right: 1px solid black;"><?php echo e($detail['quantity']); ?></td>
                    <td style="border-right: 1px solid black;"><?php echo e($detail['taxe']); ?></td>
                    <td><?php echo e($detail['total']); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr style="border: none;">
                <td></td>
                <td></td>
                <td></td>
                <td style="border: 1px solid black;"><span>Total H.T</span></td>
                <td style="border: 1px solid black;"><span><?php echo e($purchase['DisplayGrandTotal']); ?></span></td>
            </tr>
            <tr style="border: none;">
                <td></td>
                <td></td>
                <td></td>
                <td style="border: 1px solid black;"><span>TVA <?php echo e($purchase['tax_rate']); ?>%</span></td>
                <td style="border: 1px solid black;">
                    <span><?php echo e($purchase['GrandTotal'] * ($purchase['tax_rate'] != 0 ? $purchase['tax_rate'] / 100 : 0)); ?></span>
                </td>
            </tr>
            <tr style="border: none;">
                <td></td>
                <td></td>
                <td></td>
                <td style="border: 1px solid black;"><span>Net a Payer En DH</span></td>
                <td style="border: 1px solid black;"><span><?php echo e($purchase['GrandTotal']); ?></span></td>
            </tr>
        </table>
    </div>

    <br />
    <br />

    <table style="width: 100%; text-align: center;">
        <tr>
            <td style="60%;"><span style="font-size: 16px; font-weight:600;">Arrêtée la présente Facture à la somme de
                    :</span></td>
            <td style="40%;"><span style="color: white;">---------------------------</span></td>
        </tr>
        <tr>
            <td><span style="font-size: 18px; font-weight:800;"><?php echo e($purchase['GrandTotalWord']); ?> DH.</span></td>
            <td></td>
        </tr>
    </table>

    <br />
    <br />

    <div style="text-align: center;">
        <?php if($societe->name == 'FUNCHAL TRANS SARL'): ?>
            FUNCHAL TRANS SARL<br />
            E-MAIL :funchaltrans@gmail.com -Tél: 0689821150<br />
            RIB: 007 640 0013685000000074 39 (Attijariwafabank) CODE SWIFT :BCMAMAMC <br />
            ICE: 001977783000008
        <?php endif; ?>
        <?php if($societe->name == 'FLORENCIA TRANS SARL'): ?>
            FLORENCIA TRANS SARL<br />
            E-MAIL : florenciatrans2021@gmail.com-Tél: 0689821150<br />
            RIB: 007 640 0013689000000145 97 (Attijariwafabank) CODE SWIFT : BCMAMAMC<br />
            ICE : 002745451000029
        <?php endif; ?>
        <?php if($societe->name == 'TRANSLOGIA SARL'): ?>
            TRANSLOGIA SARL<br />
            E-MAIL : translogia2022@gmail.com – TEL : 0689821150<br />
            RIB: 007 640 0013688000000218 77 (Attijariwafabank) CODE SWIFT : BCMAMAMC<br />
            ICE : 003115954000058
        <?php endif; ?>
    </div>
</body>

</html>
<?php /**PATH D:\Projects\_Enterprises\MARVENCLUES\Funchal\funchal\resources\views/pdf/purchase_pdf.blade.php ENDPATH**/ ?>