<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <title>Supplier  : <?php echo e($provider['provider_name']); ?></title>
      <link rel="stylesheet" href="<?php echo e(public_path('css/pdf_style.css')); ?>" media="all" />
   </head>

   <body>
      <header class="clearfix">
         <div id="logo">
         <img src="<?php echo e(asset('/images/'.$setting['logo'])); ?>">
         </div>
        
         <div id="Title-heading">
               Supplier  : <?php echo e($provider['provider_name']); ?>

         </div>
         </div>
      </header>
      <main>
         <div id="details" class="clearfix">
            <div id="client">
               <table class="table-sm">
                  <thead>
                     <tr>
                        <th class="desc">Supplier Details</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                           <div><strong>Name:</strong> <?php echo e($provider['provider_name']); ?></div>
                           <div><strong>Phone:</strong> <?php echo e($provider['phone']); ?></div>
                           <div><strong>Total Purchases:</strong> <?php echo e($provider['total_purchase']); ?></div>
                           <div><strong>Total Amount:</strong> <?php echo e($symbol); ?> <?php echo e($provider['total_amount']); ?></div>
                           <div><strong>Total Paid:</strong> <?php echo e($symbol); ?> <?php echo e($provider['total_paid']); ?></div>
                           <div><strong>Total Purchases Due:</strong> <?php echo e($symbol); ?> <?php echo e($provider['due']); ?></div>
                           <div><strong>Total Purchase Return Due:</strong> <?php echo e($symbol); ?> <?php echo e($provider['return_Due']); ?></div>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
            <div id="invoice">
               <table class="table-sm">
                  <thead>
                     <tr>
                        <th class="desc">Company Info</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                           <div id="comp"><?php echo e($setting['CompanyName']); ?></div>
                           <div><strong>Address:</strong>  <?php echo e($setting['CompanyAdress']); ?></div>
                           <div><strong>Phone:</strong>  <?php echo e($setting['CompanyPhone']); ?></div>
                           <div><strong>Email:</strong>  <?php echo e($setting['email']); ?></div>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </div>
         </div>
         <div id="details_inv">
            <h3 style="margin-bottom:10px">
                  All Purchases ( Unpaid/Partial )
            </h3>
            <table  class="table-sm">
               <thead>
                  <tr>
                     <th>DATE</th>
                     <th>REF</th>
                     <th>PAID</th>
                     <th>DUE</th>
                     <th>PAYMENT STATUS</th>
                  </tr>
               </thead>
               <tbody>
                  <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                     <td><?php echo e($purchase['date']); ?> </td>
                     <td><?php echo e($purchase['Ref']); ?></td>
                     <td><?php echo e($symbol); ?> <?php echo e($purchase['paid_amount']); ?> </td>
                     <td><?php echo e($symbol); ?> <?php echo e($purchase['due']); ?> </td>
                     <td><?php echo e($purchase['payment_status']); ?> </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
               </tbody>
            </table>
         </div>
      </main>
   </body>
</html>
<?php /**PATH /home/funchal.fildaro.ma/public_html/resources/views/pdf/report_provider_pdf.blade.php ENDPATH**/ ?>