<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Bon de commande - {{ $purchase['Ref'] }}</title>
    <link rel="stylesheet" href="{{ public_path('css/pdf_style.css') }}" media="all" />
</head>

<body>
    <header style="text-align: center;">
        <img src="{{ public_path('/images/' . $societe_logo) }}" width="100%">
    </header>

    <table style="width: 100%;">
        <tr>

            <td>
                @if ($societe->name == 'FUNCHAL TRANS SARL')
                    <span style="font-size: 15px; font-weight: 700;">FUNCHAL TRANS SARL</span><br />
                    Résidence habiba 2 etg n°56 Tanger.<br />
                    R.C:85291 -T.P:57102685<br />
                    IF : 24934253 - CNSS : 5668308
                @endif
            </td>
            <td style="width: 60%;" rowspan="2">
                <div style="border: 3px solid black; font-size: 16px; font-weight: 700; padding: 20px">
                    Fournisseur : {{ $purchase['supplier_name'] }}<br />
                    ICE : {{ $purchase['supplier_tax'] }}<br />
                    ADRESSE : {{ $purchase['supplier_adr'] }}
                </div>
            </td>

        </tr>
        <tr>
            <td>
                <span style="font-size: 16px; font-weight: 700; padding: 20px">
                    Bon de commande : {{ substr($purchase['Ref'], 3) }}
                </span>
            </td>
        </tr>
    </table>

    <br />

    <div style="min-height: 400px; height: auto; ">
        <div style="min-height: 400px; height: auto; border: 1px solid black;">
            <table style="width: 100%; border-collapse: collapse;">
                <tr style="border-bottom: 1px solid black;">
                    <th style="width: 12%; text-align: left; border-right: 1px solid black;">N°</th>
                    <th style="width: 55%; text-align: left; border-right: 1px solid black;">Désignation</th>
                    <th style="width: 18%; text-align: left; border-right: 1px solid black;">Qte</th>
                    <th style="width: 18%; text-align: left; border-right: 1px solid black;">Prix</th>
                    <th style="width: 15%; text-align: left;">Montant</th>
                </tr>
                @foreach ($details as $key => $detail)
                    <tr style="border-bottom: 1px solid black;">
                        {{-- <td style="border-right: 1px solid black;">{{ $detail['code'] }}</td> --}}
                        <td style="border-right: 1px solid black;">{{ $key + 1 }}</td>
                        <td style="border-right: 1px solid black;">{{ $detail['name'] }}</td>
                        <td style="border-right: 1px solid black;">{{ $detail['quantity'] }}</td>
                        <td style="border-right: 1px solid black;">{{ $detail['taxe'] }}</td>
                        <td>{{ $detail['total'] }}</td>
                    </tr>
                @endforeach
            </table>
        </div>
        <table style="width: 100%; border-collapse: collapse;">
            <tr style="border: none;">
                <td></td>
                <td></td>
                <td></td>
                <td style="width: 20%; border: 1px solid black; border-top: none;"><span>Total H.T</span></td>
                <td style="width: 20%; border: 1px solid black; border-top: none;">
                    <span>{{ $purchase['DisplayGrandTotal'] }}</span>
                </td>
            </tr>
            <tr style="border: none;">
                <td></td>
                <td></td>
                <td></td>
                <td style="width: 20%; border: 1px solid black;"><span>TVA {{ $purchase['tax_rate'] }}%</span></td>
                <td style="width: 20%; border: 1px solid black;">
                    <span>{{ $purchase['GrandTotal'] * ($purchase['tax_rate'] != 0 ? $purchase['tax_rate'] / 100 : 0) }}</span>
                </td>
            </tr>
            <tr style="border: none;">
                <td></td>
                <td></td>
                <td></td>
                <td style="width: 20%; border: 1px solid black;"><span>Net a Payer En DH</span></td>
                <td style="width: 20%; border: 1px solid black;"><span>{{ $purchase['GrandTotal'] }}</span></td>
            </tr>
        </table>
    </div>

    <br />
    <br />

    <table style="width: 100%; text-align: center;">
        <tr>
            <td style="60%;"><span style="font-size: 16px; font-weight:600;">Arrêtée la présente Facture à la somme de
                    :</span></td>
            <td style="40%;"><span style="color: white;">---------------------------</span></td>
        </tr>
        <tr>
            <td><span style="font-size: 18px; font-weight:800;">{{ $purchase['GrandTotalWord'] }} DH.</span></td>
            <td></td>
        </tr>
    </table>

    <br />
    <br />

    <div style="text-align: center;">
        @if ($societe->name == 'FUNCHAL TRANS SARL')
            FUNCHAL TRANS SARL<br />
            E-MAIL :funchaltrans@gmail.com -Tél: 0689821150<br />
            RIB: 007 640 0013685000000074 39 (Attijariwafabank) CODE SWIFT :BCMAMAMC <br />
            ICE: 001977783000008
        @endif
        @if ($societe->name == 'FLORENCIA TRANS SARL')
            FLORENCIA TRANS SARL<br />
            E-MAIL : florenciatrans2021@gmail.com-Tél: 0689821150<br />
            RIB: 007 640 0013689000000145 97 (Attijariwafabank) CODE SWIFT : BCMAMAMC<br />
            ICE : 002745451000029
        @endif
        @if ($societe->name == 'TRANSLOGIA SARL')
            TRANSLOGIA SARL<br />
            E-MAIL : translogia2022@gmail.com – TEL : 0689821150<br />
            RIB: 007 640 0013688000000218 77 (Attijariwafabank) CODE SWIFT : BCMAMAMC<br />
            ICE : 003115954000058
        @endif
    </div>
</body>

</html>
