<?php

use App\Models\Purchase;
use Database\Seeders\BrandSeeder;
use Database\Seeders\CategorySeeder;
use Database\Seeders\ProductSeeder;
use Database\Seeders\ProviderSeeder;
use Database\Seeders\PurchaseSeeder;
use Database\Seeders\SaleSeeder;
use Database\Seeders\SocieteSeeder;
use Database\Seeders\UnitSeeder;
use Database\Seeders\VehiculeSeeder;
use Database\Seeders\WarehouseSeeder;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{

    protected $models = [
        'AdjustmentDetail',
        'Adjustment',
        'Attendance',
        'Brand',
        'Category',
        'Chiffeur',
        'Client',
        'Company',
        'Currency',
        'Department',
        'Designation',
        'EmailMessage',
        'EmployeeAccount',
        'EmployeeExperience',
        'Employee',
        'ExpenseCategory',
        'Expense',
        'ExpensePurchase',
        'Holiday',
        'Leave',
        'LeaveType',
        'OauthAccessToken',
        'OauthRefreshToken',
        'OfficeShift',
        'PasswordReset',
        'PaymentPurchase',
        'PaymentPurchaseReturns',
        'PaymentSale',
        'PaymentSaleReturns',
        'PaymentWithCreditCard',
        'Permission',
        'PosSetting',
        'Product',
        'ProductVariant',
        'product_warehouse',
        'Provider',
        'PurchaseDetail',
        'Purchase',
        'PurchaseReturnDetails',
        'PurchaseReturn',
        'QuotationDetail',
        'Quotation',
        'Role',
        'role_user',
        'SaleDetail',
        'Sale',
        'SaleReturnDetails',
        'SaleReturn',
        'Server',
        'Setting',
        'Shipment',
        'sms_gateway',
        'SMSMessage',
        'Societe',
        'TransferDetail',
        'Transfer',
        'Unit',
        'User',
        'UserWarehouse',
        'Vehicule',
        'Voyage',
        'Warehouse',
    ];
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {

        $this->call([
            VehiculeSeeder::class,
            ProviderSeeder::class,
            SocieteSeeder::class,
            WarehouseSeeder::class,
            ClientSeeder::class,
            CurrencySeeder::class,
            SettingSeeder::class,
            ServerSeeder::class,
            PermissionsSeeder::class,
            RoleSeeder::class,
            UserSeeder::class,
            UserRoleSeeder::class,
            PermissionRoleSeeder::class,

            BrandSeeder::class,
            CategorySeeder::class,
            SaleSeeder::class,
            PurchaseSeeder::class,
            UnitSeeder::class,
            ProductSeeder::class,
        ]);
    }
}
