<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddChiffeurVoyageColsInExpensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('expenses', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->string('source')->default('intern');
            $table->integer('societe_id');
            $table->foreign('societe_id')->references('id')->on('societes')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->integer('sale_id')->nullable();
            $table->foreign('sale_id')->references('id')->on('sales')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->integer('chiffeur_id')->nullable();
            $table->foreign('chiffeur_id')->references('id')->on('chiffeurs')->onUpdate('RESTRICT')->onDelete('RESTRICT');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('expenses', function (Blueprint $table) {
            //
        });
    }
}
