<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddChiffeurManyToManyRelationWithSalesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('chiffeur_sales', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->id();
            $table->integer('sale_id');
            $table->integer('chiffeur_id');
            $table->timestamps();

            $table->foreign('sale_id')->references('id')->on('sales')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->foreign('chiffeur_id')->references('id')->on('chiffeurs')->onUpdate('RESTRICT')->onDelete('RESTRICT');

            $table->index(['sale_id', 'chiffeur_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('chiffeur_sale');
    }
}
