<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColsInSalesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sales', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->integer('societe_id')->nullable()->after('Ref')->index('sale_id_societes');
            $table->foreign('societe_id', 'sale_id_societes')->references('id')->on('societes')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->string('n_dossier')->nullable();
            $table->string('classement')->nullable();
            $table->string('exp_imp')->nullable();
            $table->string('n_facture')->nullable();
            $table->string('mtr')->nullable();
            $table->string('exp_invoce_nbr')->nullable();
            $table->string('trafis_dh')->nullable();
            $table->string('euros')->nullable();
            $table->string('devis_type')->default('DH')->nullable();
            $table->string('crm')->nullable();
            $table->integer('voyage_id')->nullable()->index('sale_id_voyages');
            $table->foreign('voyage_id', 'sale_id_voyages')->references('id')->on('voyages')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->string('sortie')->nullable();
            $table->integer('vehicule_1_id')->nullable()->index('sale_id_vehicule_1s');
            $table->foreign('vehicule_1_id', 'sale_id_vehicule_1s')->references('id')->on('vehicules')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->integer('vehicule_2_id')->nullable()->index('sale_id_vehicule_2s');
            $table->foreign('vehicule_2_id', 'sale_id_vehicule_2s')->references('id')->on('vehicules')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->integer('vehicule_3_id')->nullable()->index('sale_id_vehicule_3s');
            $table->foreign('vehicule_3_id', 'sale_id_vehicule_3s')->references('id')->on('vehicules')->onUpdate('RESTRICT')->onDelete('RESTRICT');
            $table->date('mlv')->nullable();
            $table->string('bl')->nullable();
            $table->string('bateau')->nullable();
            $table->float('DisplayGrandTotal')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sales', function (Blueprint $table) {
            //
        });
    }
}
