<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddVoitureInChiffeursTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('chiffeurs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->integer('vehicule_id')->nullable()->after('email')->index('chiffeur_id_vehicules');
            $table->foreign('vehicule_id', 'chiffeur_id_vehicules')->references('id')->on('vehicules')->onUpdate('RESTRICT')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('chiffeurs', function (Blueprint $table) {
            //
        });
    }
}
