<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChiffeursTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('chiffeurs', function (Blueprint $table) {
			$table->engine = 'InnoDB';
			$table->integer('id', true);
			$table->string('firstname');
			$table->string('lastname');
			$table->string('email', 192);
			$table->string('avatar')->nullable();
			$table->string('phone', 192);
			$table->timestamps(6);
			$table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('chiffeurs');
    }
}
