<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSocietesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('societes', function (Blueprint $table) {
			$table->engine = 'InnoDB';
			$table->integer('id', true);
			$table->string('name', 191);
			$table->string('email', 191)->nullable();
			$table->string('number', 191)->nullable();
			$table->text('address')->nullable();
			$table->string('ice', 255)->nullable();
			$table->timestamps(6);
			$table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('societes');
    }
}
