<?php

namespace App\Policies;

use App\Models\Chiffeur;
use App\Models\Permission;
use Illuminate\Auth\Access\HandlesAuthorization;

class ChiffeurPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the chiffeur can view any models.
     *
     * @param  \App\Models\Chiffeur  $chiffeur
     * @return mixed
     */
    public function viewAny(Chiffeur $chiffeur)
    {
        //
    }

    /**
     * Determine whether the chiffeur can view the model.
     *
     * @param  \App\Models\Chiffeur  $chiffeur
     * @param  \App\Models\Chiffeur  $model
     * @return mixed
     */
    public function view(Chiffeur $chiffeur)
    {
        $permission = Permission::where('name', 'chiffeurs_view')->first();
        return $chiffeur->hasRole($permission->roles);
    }

    /**
     * Determine whether the chiffeur can create models.
     *
     * @param  \App\Models\Chiffeur  $chiffeur
     * @return mixed
     */
    public function create(Chiffeur $chiffeur)
    {
        $permission = Permission::where('name', 'chiffeurs_add')->first();
        return $chiffeur->hasRole($permission->roles);
    }

    /**
     * Determine whether the chiffeur can update the model.
     *
     * @param  \App\Models\Chiffeur  $chiffeur
     * @param  \App\Models\Chiffeur  $model
     * @return mixed
     */
    public function update(Chiffeur $chiffeur)
    {
        $permission = Permission::where('name', 'chiffeurs_edit')->first();
        return $chiffeur->hasRole($permission->roles);
    }

    /**
     * Determine whether the chiffeur can delete the model.
     *
     * @param  \App\Models\Chiffeur  $chiffeur
     * @param  \App\Models\Chiffeur  $model
     * @return mixed
     */
    public function delete(Chiffeur $chiffeur)
    {
        $permission = Permission::where('name', 'chiffeurs_delete')->first();
        return $chiffeur->hasRole($permission->roles);
    }

    public function backup(Chiffeur $chiffeur)
    {
        $permission = Permission::where('name', 'backup')->first();
        return $chiffeur->hasRole($permission->roles);
    }

    public function chiffeurs_report(Chiffeur $chiffeur)
    {
        $permission = Permission::where('name', 'chiffeurs_report')->first();
        return $chiffeur->hasRole($permission->roles);
    }


    /**
     * Determine whether the chiffeur can restore the model.
     *
     * @param  \App\Models\Chiffeur  $chiffeur
     * @param  \App\Models\Chiffeur  $model
     * @return mixed
     */
    public function restore(Chiffeur $chiffeur)
    {
        //
    }

    /**
     * Determine whether the chiffeur can permanently delete the model.
     *
     * @param  \App\Models\Chiffeur  $chiffeur
     * @param  \App\Models\Chiffeur  $model
     * @return mixed
     */
    public function forceDelete(Chiffeur $chiffeur)
    {
        //
    }
}
