<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    use HasFactory;
    
    protected $dates = ['deleted_at'];

    protected $fillable = [
        'date', 'Ref', 'is_pos', 'client_id', 'GrandTotal', 'qte_retturn', 'TaxNet', 'tax_rate', 'notes',
        'total_retturn', 'warehouse_id', 'user_id', 'statut', 'discount', 'shipping',
        'paid_amount', 'payment_statut', 'created_at', 'updated_at', 'deleted_at','shipping_status',
        'societe_id', 'n_dossier', 'classement', 'exp_imp', 'n_facture', 'mtr', 'devis_type', 'voyage_id', 'exp_invoce_nbr', 'crm', 'chiffeur_id', 'sortie', 'vehicule_1_id', 'vehicule_2_id', 'vehicule_3_id', 'mlv', 'bl', 'bateau', 'DisplayGrandTotal', 'try', 'taux'
    ];
    
    protected $casts = [
        'is_pos' => 'integer',
        'taux' => 'double',
        'DisplayGrandTotal' => 'double',
        'GrandTotal' => 'double',
        'qte_retturn' => 'double',
        'total_retturn' => 'double',
        'user_id' => 'integer',
        'client_id' => 'integer',
        'warehouse_id' => 'integer',
        'discount' => 'double',
        'shipping' => 'double',
        'TaxNet' => 'double',
        'tax_rate' => 'double',
        'paid_amount' => 'double',
    ];

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function chiffeurs()
    {
        return $this->belongsToMany(Chiffeur::class, 'chiffeur_sales');
    }

    public function details()
    {
        return $this->hasMany('App\Models\SaleDetail');
    }

    public function societe()
    {
        return $this->belongsTo('App\Models\Societe');
    }
    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }
    public function vehicule1()
    {
        return $this->belongsTo('App\Models\Vehicule', 'vehicule_1_id');
    }
    public function vehicule2()
    {
        return $this->belongsTo('App\Models\Vehicule', 'vehicule_2_id');
    }
    public function vehicule3()
    {
        return $this->belongsTo('App\Models\Vehicule', 'vehicule_3_id');
    }
    public function voyage()
    {
        return $this->belongsTo('App\Models\Voyage');
    }

    public function facture()
    {
        return $this->hasMany('App\Models\PaymentSale');
    }

    public function warehouse()
    {
        return $this->belongsTo('App\Models\Warehouse');
    }

}
