<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Provider extends Model
{
    use HasFactory;
    
    protected $dates = ['deleted_at'];

    protected $fillable = [
        'name', 'code', 'adresse', 'phone', 'country', 'email', 'city','tax_number'
    ];

    protected $casts = [
        'code' => 'integer',
    ];

    public function purchases()
    {
        return $this->hasMany('App\Models\Purchase');
    }

}
