<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chiffeur extends Model
{
    use HasFactory;

    protected $dates = ['deleted_at'];

    protected $fillable = [
        'firstname', 'lastname', 'email', 'phone', 'avatar', 'vehicule_id'
    ];

    public function sales()
    {
        return $this->belongsToMany(Sale::class, 'chiffeur_sales');
    }

    public function expenses()
    {
        return $this->hasMany(Expense::class);
    }
}
