<?php

namespace App\Http\Controllers;

use App\Models\Expense;
use App\Models\Role;
use App\Models\Sale;
use App\Models\Setting;
use App\Models\Chiffeur;
use App\Models\product_warehouse;
use App\Models\Vehicule;
use App\Models\Warehouse;
use App\utils\helpers;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Intervention\Image\ImageManagerStatic as Image;
use \Nwidart\Modules\Facades\Module;

class ChiffeurController extends BaseController
{

    //------------- GET ALL CHIFFEURS ---------\\

    public function index(request $request)
    {

        // $this->authorizeForUser($request->chiffeur('api'), 'view', Chiffeur::class);
        // How many items do you want to display.
        $perPage = $request->limit;
        $pageStart = \Request::get('page', 1);
        // Start displaying items from this number;
        $offSet = ($pageStart * $perPage) - $perPage;
        $order = $request->SortField;
        $dir = $request->SortType;
        $helpers = new helpers();
        // Filter fields With Params to retrieve
        $columns = array(0 => 'firstname', 1 => 'lastname', 2 => 'phone', 3 => 'email');
        $param = array(0 => 'like', 1 => '=', 2 => 'like', 3 => 'like');
        $data = array();

        $Role = Auth::user()->roles()->first();
        $ShowRecord = Role::findOrFail($Role->id)->inRole('record_view');

        $chiffeurs = Chiffeur::where(function ($query) use ($ShowRecord) {
            if (!$ShowRecord) {
                return $query->where('id', '=', Auth::user()->id);
            }
        });

        //Multiple Filter
        $Filtred = $helpers->filter($chiffeurs, $columns, $param, $request)
        // Search With Multiple Param
            ->where(function ($query) use ($request) {
                return $query->when($request->filled('search'), function ($query) use ($request) {
                    return $query->where('firstname', 'LIKE', "%{$request->search}%")
                        ->orWhere('lastname', 'LIKE', "%{$request->search}%")
                        ->orWhere('email', 'LIKE', "%{$request->search}%")
                        ->orWhere('phone', 'LIKE', "%{$request->search}%");
                });
            });
        $totalRows = $Filtred->count();
        if($perPage == "-1"){
            $perPage = $totalRows;
        }
        $chiffeurs = $Filtred->offset($offSet)
            ->limit($perPage)
            ->orderBy($order, $dir)
            ->get();

        foreach ($chiffeurs as $chiffeur) {

            $item['vehicule'] = DB::table('vehicules')
                ->find($chiffeur->vehicule_id)
                ->matricule;
            $item['id'] = $chiffeur->id;
            $item['firstname'] = $chiffeur->firstname;
            $item['lastname'] = $chiffeur->lastname;
            $item['email'] = $chiffeur->email;
            $item['phone'] = $chiffeur->phone;

            $vehicule = DB::table('vehicules')->find($chiffeur->vehicule_id);
            $item['vehicule'] = $vehicule ? $vehicule->matricule : null;
        
            // $item['total_sales'] = Sale::where('vehicule_1_id', $chiffeur->vehicule_id)
            //     ->orWhere('vehicule_2_id', $chiffeur->vehicule_id)
            //     ->orWhere('vehicule_3_id', $chiffeur->vehicule_id)
            //     ->sum('GrandTotal');

            // $item['total_expenses'] = Expense::join('chiffeurs as c', 'expenses.chiffeur_id', '=', 'c.id')
            //     ->where('c.id', $chiffeur->id)
            //     ->sum('amount');

            $data[] = $item;
        }

        $vehicules = Vehicule::where('deleted_at', null)->get(['id', 'matricule']);

        return response()->json([
            'chiffeurs' => $data,
            'vehicules' => $vehicules,
            'totalRows' => $totalRows,
        ]);
    }

    //------------- STORE NEW CHIFFEUR ---------\\

    public function store(Request $request)
    {
        // $this->authorizeForUser($request->chiffeur('api'), 'create', Chiffeur::class);
        $this->validate($request, [
            'email' => 'required|unique:chiffeurs',
        ], [
            'email.unique' => 'This Email already taken.',
        ]);
        \DB::transaction(function () use ($request) {
            if ($request->hasFile('avatar')) {

                $image = $request->file('avatar');
                $filename = rand(11111111, 99999999) . $image->getClientOriginalName();

                $image_resize = Image::make($image->getRealPath());
                $image_resize->resize(128, 128);
                $image_resize->save(public_path('/images/avatar/' . $filename));

            } else {
                $filename = 'no_avatar.png';
            }

            $Chiffeur = new Chiffeur;
            $Chiffeur->firstname = $request['firstname'];
            $Chiffeur->lastname  = $request['lastname'];
            $Chiffeur->email     = $request['email'];
            $Chiffeur->phone     = $request['phone'];
            $Chiffeur->vehicule_id     = $request['vehicule_id'];
            $Chiffeur->avatar    = $filename;
            $Chiffeur->save();    
        }, 10);
        

        return response()->json(['success' => true]);
    }

    //------------ function show -----------\\

    public function show($id){
        //
        
    }

    public function edit(Request $request, $id)
    {
        // $this->authorizeForUser($request->chiffeur('api'), 'update', Chiffeur::class);

        return response()->json([
            'assigned_vehicule' => Chiffeur::find($id)->vehicule_id
        ]);
    }

    //------------- UPDATE  CHIFFEUR ---------\\

    public function update(Request $request, $id)
    {        
        // $this->authorizeForUser($request->chiffeur('api'), 'update', Chiffeur::class);
        
        $this->validate($request, [
            'email' => Rule::unique('chiffeurs')->ignore($id),
        ], [
            'email.unique' => 'This Email already taken.',
        ]);

        \DB::transaction(function () use ($id ,$request) {
            $chiffeur = Chiffeur::findOrFail($id);
            $current = $chiffeur->password;

            $currentAvatar = $chiffeur->avatar;
            if ($request->has('avatar') && !empty($request->avatar) && $request->avatar!='undefined' && $request->avatar != $currentAvatar) {

                $image = $request->file('avatar');
                $path = public_path() . '/images/avatar';
                $filename = rand(11111111, 99999999) . $image->getClientOriginalName();

                $image_resize = Image::make($image->getRealPath());
                $image_resize->resize(128, 128);
                $image_resize->save(public_path('/images/avatar/' . $filename));

                $userPhoto = $path . '/' . $currentAvatar;
                if (file_exists($userPhoto)) {
                    if ($chiffeur->avatar != 'no_avatar.png') {
                        @unlink($userPhoto);
                    }
                }
            } else {
                $filename = $currentAvatar;
            }

            Chiffeur::whereId($id)->update([
                'firstname' => $request['firstname'],
                'lastname' => $request['lastname'],
                'email' => $request['email'],
                'phone' => $request['phone'],
                'vehicule_id' => $request['vehicule_id'],
                'avatar' => $filename
            ]);

        }, 10);
        
        return response()->json(['success' => true]);

    }
}
